/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (ivec2(13, 26) >> ivec2(13, 26)) => ivec2(0, 0)
 * (ivec2(13, 26) >> ivec2(2, 26)) => ivec2(3, 0)
 * (ivec2(-2, 26) >> ivec2(13, 26)) => ivec2(-1, 0)
 * (ivec2(-2, 26) >> ivec2(2, 26)) => ivec2(-1, 0)
 * (ivec2(2, 26) >> ivec2(13, 26)) => ivec2(0, 0)
 * (ivec2(2, 26) >> ivec2(2, 26)) => ivec2(0, 0)
 */
#version 150

void main()
{
  float[all(equal((ivec2(13, 26) >> ivec2(13, 26)), ivec2(0, 0))) ? 1 : -1] array0;
  float[all(equal((ivec2(13, 26) >> ivec2(2, 26)), ivec2(3, 0))) ? 1 : -1] array1;
  float[all(equal((ivec2(-2, 26) >> ivec2(13, 26)), ivec2(-1, 0))) ? 1 : -1] array2;
  float[all(equal((ivec2(-2, 26) >> ivec2(2, 26)), ivec2(-1, 0))) ? 1 : -1] array3;
  float[all(equal((ivec2(2, 26) >> ivec2(13, 26)), ivec2(0, 0))) ? 1 : -1] array4;
  float[all(equal((ivec2(2, 26) >> ivec2(2, 26)), ivec2(0, 0))) ? 1 : -1] array5;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length());
}
