"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const buffalo_1 = require("../../../buffalo");
const parameterType_1 = __importDefault(require("./parameterType"));
class BuffaloZnp extends buffalo_1.Buffalo {
    readListNetwork(length) {
        const value = [];
        for (let i = 0; i < length; i++) {
            const neightborPanId = this.readUInt16();
            const logicalChannel = this.readUInt8();
            const value1 = this.readUInt8();
            const value2 = this.readUInt8();
            const permitJoin = this.readUInt8();
            value.push({
                neightborPanId,
                logicalChannel,
                stackProfile: value1 & 0x0f,
                zigbeeVersion: (value1 & 0xf0) >> 4,
                beaconOrder: value2 & 0x0f,
                superFrameOrder: (value2 & 0xf0) >> 4,
                permitJoin,
            });
        }
        return value;
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    write(type, value, options) {
        switch (type) {
            case parameterType_1.default.UINT8: {
                return this.writeUInt8(value);
            }
            case parameterType_1.default.UINT16: {
                return this.writeUInt16(value);
            }
            case parameterType_1.default.UINT32: {
                return this.writeUInt32(value);
            }
            case parameterType_1.default.IEEEADDR: {
                return this.writeIeeeAddr(value);
            }
            case parameterType_1.default.BUFFER: {
                return this.writeBuffer(value, options.length ?? value.length);
            }
            case parameterType_1.default.BUFFER8: {
                return this.writeBuffer(value, 8);
            }
            case parameterType_1.default.BUFFER16: {
                return this.writeBuffer(value, 16);
            }
            case parameterType_1.default.BUFFER18: {
                return this.writeBuffer(value, 18);
            }
            case parameterType_1.default.BUFFER32: {
                return this.writeBuffer(value, 32);
            }
            case parameterType_1.default.BUFFER42: {
                return this.writeBuffer(value, 42);
            }
            case parameterType_1.default.BUFFER100: {
                return this.writeBuffer(value, 100);
            }
            case parameterType_1.default.LIST_UINT8: {
                return this.writeListUInt8(value);
            }
            case parameterType_1.default.LIST_UINT16: {
                return this.writeListUInt16(value);
            }
            // NOTE: not writable
            // case ParameterType.LIST_NETWORK:
            case parameterType_1.default.INT8: {
                return this.writeInt8(value);
            }
            default: {
                throw new Error(`Write for '${type}' not available`);
            }
        }
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    read(type, options) {
        switch (type) {
            case parameterType_1.default.UINT8: {
                return this.readUInt8();
            }
            case parameterType_1.default.UINT16: {
                return this.readUInt16();
            }
            case parameterType_1.default.UINT32: {
                return this.readUInt32();
            }
            case parameterType_1.default.IEEEADDR: {
                return this.readIeeeAddr();
            }
            case parameterType_1.default.BUFFER: {
                if (options.length == null) {
                    throw new Error('Cannot read BUFFER without length option specified');
                }
                return this.readBuffer(options.length);
            }
            case parameterType_1.default.BUFFER8: {
                return this.readBuffer(8);
            }
            case parameterType_1.default.BUFFER16: {
                return this.readBuffer(16);
            }
            case parameterType_1.default.BUFFER18: {
                return this.readBuffer(18);
            }
            case parameterType_1.default.BUFFER32: {
                return this.readBuffer(32);
            }
            case parameterType_1.default.BUFFER42: {
                return this.readBuffer(42);
            }
            case parameterType_1.default.BUFFER100: {
                return this.readBuffer(100);
            }
            case parameterType_1.default.LIST_UINT8: {
                if (options.length == null) {
                    throw new Error('Cannot read LIST_UINT8 without length option specified');
                }
                return this.readListUInt8(options.length);
            }
            case parameterType_1.default.LIST_UINT16: {
                if (options.length == null) {
                    throw new Error('Cannot read LIST_UINT16 without length option specified');
                }
                return this.readListUInt16(options.length);
            }
            case parameterType_1.default.LIST_NETWORK: {
                if (options.length == null) {
                    throw new Error('Cannot read LIST_NETWORK without length option specified');
                }
                return this.readListNetwork(options.length);
            }
            case parameterType_1.default.INT8: {
                return this.readInt8();
            }
            default: {
                throw new Error(`Read for '${type}' not available`);
            }
        }
    }
}
exports.default = BuffaloZnp;
//# sourceMappingURL=buffaloZnp.js.map