/* : : generated by lcgen : : */

#ifndef _LC_H
#define _LC_H			1

#include <ast.h>

#define LC_abbreviated		0x00001
#define LC_checked		0x00002
#define LC_debug		0x00004
#define LC_default		0x00008
#define LC_defined		0x00010
#define LC_local		0x00020
#define LC_primary		0x00040
#define LC_qualified		0x00080
#define LC_undefined		0x00100
#define LC_utf8			0x00200
#define LC_verbose		0x00400
#define LC_setlocale		0x10000
#define LC_setenv		0x20000
#define LC_user			0x40000

#define LC_language_attribute_max	2
#define LC_territory_language_max	4

struct Lc_s;

typedef struct Lc_info_s
{
	const struct Lc_s*	lc;
	unsigned long		number;
	void*			data;
} Lc_info_t;

typedef struct Lc_attribute_s
{
	const char*		name;
	unsigned long		flags;
	unsigned long		index;
} Lc_attribute_t;

typedef struct Lc_charset_s
{
	const char*		code;
	const char*		alternates;
	const char*		ms;
	unsigned long		index;
} Lc_charset_t;

typedef struct Lc_language_s
{
	const char*		code;
	const char*		name;
	const char*		alternates;
	const Lc_charset_t*	charset;
	unsigned long		flags;
	unsigned long		index;
	const Lc_attribute_t*	attributes[LC_language_attribute_max];
} Lc_language_t;

typedef struct Lc_territory_s
{
	const char*		code;
	const char*		name;
	unsigned long		flags;
	unsigned long		index;
	const Lc_language_t*	languages[LC_territory_language_max];
#ifdef _LC_TERRITORY_PRIVATE_
	_LC_TERRITORY_PRIVATE_
#endif
} Lc_territory_t;

typedef struct Lc_map_s
{
	const char*		code;
	const Lc_language_t*	language;
	const Lc_territory_t*	territory;
	const Lc_charset_t*	charset;
	const Lc_attribute_t*	attribute;
} Lc_map_t;

typedef struct Lc_attribute_list_s
{
	struct Lc_attribute_list_s*	next;
	const Lc_attribute_t*		attribute;
} Lc_attribute_list_t;

typedef struct Lc_s
{
	const char*		name;
	const char*		code;
	const Lc_language_t*	language;
	const Lc_territory_t*	territory;
	const Lc_charset_t*	charset;
	const Lc_attribute_list_t*	attributes;
	unsigned long		flags;
	unsigned long		index;
#ifdef _LC_PRIVATE_
	_LC_PRIVATE_
#endif
} Lc_t;

struct Lc_category_s;

typedef int (*Lc_category_set_f)(struct Lc_category_s*);

typedef struct Lc_category_s
{
	const char*		name;
	int			external;
	int			internal;
	Lc_category_set_f	setf;
	Lc_t*			prev;
	unsigned int		flags;
} Lc_category_t;

extern size_t		lccanon(Lc_t*, unsigned long flags, char*, size_t);
extern Lc_category_t*	lccategories(void);
extern int		lcindex(int, int);
extern Lc_info_t*	lcinfo(int);
extern Lc_t*		lcmake(const char*);
extern Lc_t*		lcscan(Lc_t*);


#endif
