"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  PLUGIN_ID: true,
  PLUGIN_NAME: true,
  PLUGIN_DESC: true
};
exports.PLUGIN_NAME = exports.PLUGIN_ID = exports.PLUGIN_DESC = void 0;
var _status = require("./status");
Object.keys(_status).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _status[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _status[key];
    }
  });
});
var _model = require("./model");
Object.keys(_model).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _model[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _model[key];
    }
  });
});
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const PLUGIN_ID = exports.PLUGIN_ID = 'ml-commons-dashboards';
const PLUGIN_NAME = exports.PLUGIN_NAME = 'Machine Learning';
const PLUGIN_DESC = exports.PLUGIN_DESC = `ML Commons for OpenSearch eases the development of machine learning features by providing a set of common machine learning (ML) algorithms through transport and REST API calls. Those calls choose the right nodes and resources for each ML request and monitors ML tasks to ensure uptime. This allows you to leverage existing open-source ML algorithms and reduce the effort required to develop new ML features.`;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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