"use strict";

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

module.exports = {
  rootDir: '../',
  setupFiles: ['<rootDir>/test/polyfills.ts', '<rootDir>/test/setupTests.ts'],
  setupFilesAfterEnv: ['<rootDir>/test/setup.jest.ts'],
  roots: ['<rootDir>'],
  coverageDirectory: './coverage',
  moduleNameMapper: {
    '\\.(css|less|scss)$': '<rootDir>/test/mocks/styleMock.ts',
    '^ui/(.*)': '<rootDir>/../../src/legacy/ui/public/$1/',
    '.*content_management/public.*': '<rootDir>/test/mocks/contentManagementMocks.ts'
  },
  coverageReporters: ['lcov', 'text', 'cobertura'],
  testMatch: ['**/*.test.js', '**/*.test.jsx', '**/*.test.ts', '**/*.test.tsx'],
  collectCoverageFrom: ['**/*.ts', '**/*.tsx', '**/*.js', '**/*.jsx', '!**/models/**', '!**/node_modules/**', '!**/index.ts', '!<rootDir>/index.js', '!<rootDir>/public/app.js', '!<rootDir>/public/temporary/**', '!<rootDir>/babel.config.js', '!<rootDir>/test/**', '!<rootDir>/server/**', '!<rootDir>/coverage/**', '!<rootDir>/scripts/**', '!<rootDir>/build/**', '!<rootDir>/cypress/**', '!**/vendor/**'],
  clearMocks: true,
  testPathIgnorePatterns: ['<rootDir>/build/', '<rootDir>/node_modules/'],
  transformIgnorePatterns: [
  // ignore all node_modules except those which require babel transforms to
  // handle newer syntax like `??=` which is not already transformed by the
  // package and not yet supported in the node version we use.
  '[/\\\\]node_modules(?![\\/\\\\](vega-lite))[/\\\\].+\\.js$'],
  modulePathIgnorePatterns: ['securityAnalyticsDashboards'],
  testEnvironment: 'jsdom',
  snapshotSerializers: ['enzyme-to-json/serializer']
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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