/* $Id: image.c,v 1.7.2.2 2001/06/29 09:53:10 tm Exp $
 * PDFlib client: image example in C
 *
 */

#include <stdio.h>
#include <stdlib.h>

#include "pdflib.h"

int
main(void)
{
    PDF *p;
    int image;
    float width, height;
    char *imagefile = "../../test/nesrin.jpg";

    p = PDF_new();

    /* open new PDF file */
    if (PDF_open_file(p, "image.pdf") == -1) {
	fprintf(stderr, "Error: couldn't open PDF file image.pdf.\n");
	exit(2);
    }

    PDF_set_info(p, "Creator", "image.c");
    PDF_set_info(p, "Author", "Thomas Merz");
    PDF_set_info(p, "Title", "image sample (C)");

    image = PDF_open_image_file(p, "jpeg", imagefile, "", 0);

    if (image == -1) {
	fprintf(stderr, "Error: couldn't open image file.\n");
	exit(3);
    }

    /* See the PDFlib manual for more advanced image size calculations */
    width = PDF_get_value(p, "imagewidth", (float) image);
    height = PDF_get_value(p, "imageheight", (float) image);

    /* We generate a page with the image's dimensions */
    PDF_begin_page(p, width, height);
    PDF_place_image(p, image, (float) 0.0, (float) 0.0, (float) 1.0);
    PDF_close_image(p, image);

    PDF_end_page(p);				/* close page		*/

    PDF_close(p);				/* close PDF document	*/

    PDF_delete(p);				/* delete the PDF object */

    return 0;
}
