// $Id: quickreference.cpp,v 1.7.2.3 2002/01/28 17:18:37 rp Exp $
//
// PDFlib/PDI client: mini imposition demo
//
#include <iostream>

#include "pdflib.hpp"

int
main(void)
{
#ifdef	PDF_THROWS_CPP_EXCEPTIONS
    try
    {
#endif
	PDFlib *p;			// pointer to the PDFlib class
	int manual, page;
	int font, row, col;
	const int maxrow = 2;
	const int maxcol = 2;
	int i, startpage = 128, endpage = 131;
	const float width = 500, height = 770;
	int pageno;
	const string infile = "../../doc/PDFlib-manual.pdf";

	p = new PDFlib();

	if (p->open("quickreference.pdf") == -1) {
	    cerr << "Error: cannot open PDF file quickreference.pdf" << endl;
	    return 99;
	}

	p->set_info("Creator", "quickreference.cpp");
	p->set_info("Author", "Thomas Merz");
	p->set_info("Title", "mini imposition demo (C++)");

	manual = p->open_pdi(infile, "", 0);
	if (manual == -1) {
	    cerr << "Error: cannot open input file " << infile << endl;
	    return 99;
	}

	row = 0;
	col = 0;

	for (pageno = startpage; pageno <= endpage; pageno++) {
	    if (row == 0 && col == 0) {
		p->begin_page(width, height);
		font = p->findfont("Helvetica-Bold", "host", 0);
		p->setfont(font, 18);
		p->set_text_pos(25, height-24);
		p->show("PDFlib 4.0 Quick Reference");
	    }

	    page = p->open_pdi_page(manual, pageno, "");

	    if (page == -1) {
		cerr << "Error: cannot open page " << pageno
		     << " in " << infile << endl;
		return 99;
	    }

	    p->place_pdi_page(manual, width/maxcol*col, height - (row + 1)
			* height/maxrow, (float) 1/maxrow, (float) 1/maxrow);
	    p->close_pdi_page(page);

	    col++;
	    if (col == maxcol) {
		col = 0;
		row++;
	    }
	    if (row == maxrow) {
		row = 0;
		p->end_page();
	    }
	}

	// finish the last partial page
	if (row != 0 || col != 0)
	    p->end_page();

	p->close();
	p->close_pdi(manual);

#ifdef	PDF_THROWS_CPP_EXCEPTIONS
    }
    catch (PDFlib::Exception &ex)
    {
	cerr << "PDFlib EXCEPTION: " << ex.get_message() << endl;
	return 99;
    }
#endif

    return 0;
}
