#!/bin/sh
#
# bbchkcfg.sh:	Check the bbdef.sh/bbinc.sh/bbsys.sh file for invalid entries
#
# Version 1.9
# Mar 13th, 2002
#
# (c) Copyright Quest Software, Inc.  1997-2002  All rights reserved.
#

# Check if the BB program paths are correct
#
# exec < /dev/null

echo
echo "If any comments are displayed, please fix the entries in your configuration"
echo

OLDIFS=$IFS
IFS='='
set `grep "^BBHOME" ../runbb.sh 2>/dev/null` >/dev/null 2>&1
IFS=$OLDIFS
if [ "$#" -ne 2 ]
then
	echo "BBHOME is not set in runbb.sh"
else
	bbhome=`eval "echo $2"`
	if [ ! -d "$bbhome" ]
	then
		echo "\"$bbhome\" is not a valid directory for BBHOME"
	fi
fi


BBHOME=$bbhome
$BBHOME/etc/bbchkcmds.sh

. ./bbdef.sh


if [ ! -z "${LOCKPREFIX}" ]
then
	OLDIFS=$IFS
	IFS='/'
	set ${LOCKPREFIX}
	IFS=$OLDIFS
	# Add root / for Solaris
	# Thanks to  Laurinda Chamberlin <lchamber@fcpa.fujitsu.com>
	directory=/${1}
	shift
	while [ "$#" -gt 1 ]
	do
		directory=${directory}/${1}
		shift
	done	
	if [ ! -d "${directory}" ]
	then
		echo "LOCKPREFIX=$LOCKPREFIX is not a valid entry"
	fi
fi

if [ -f bbwarnsetup.cfg ]
then

TTYLINE=`grep "^ttyline:" bbwarnsetup.cfg` 2>/dev/null
if [ "$?" -ne 0 ]
then
	echo "bbwarnsetup.cfg:  ttyline token was not found"
	echo "			Numeric paging notification will be disabled"
else
	set $TTYLINE >/dev/null 2>&1
	if [ "$#" -eq 1 ]
	then
		echo "bbwarnsetup.cfg:	ttyline token is not defined"
		echo "			Numeric paging notification will not work"
	else
		shift		# remove token from line
		TTYLINE=$*
		for ttyline in $TTYLINE
		do
			if [ ! -c "$ttyline" ]
			then
				echo "bbwarnsetup.cfg: $ttyline is an invalid entry in the ttyline token"
				echo "                 This is a valid error only if this host is a BBPAGER host"
			fi
		done
	fi
fi

PAGEDELAY=`grep "^pagedelay:" $BBHOME/etc/bbwarnsetup.cfg` 2>/dev/null
if [ "$?" -eq 0 ]
then
        set $PAGEDELAY >/dev/null 2>&1
        if [ "$#" -gt 1 ]
        then 
                shift           # remove pagedelay token from line
                PAGEDELAY="$1"
                # Check if it's a valid parameter
                expr "$PAGEDELAY" + 0 >/dev/null 2>&1
                if [ "$?" -ne 0 ]
                then
			echo "bbwarnsetup.cfg: The value \"$PAGEDELAY\" is invalid for the pagedelay token"
                fi
        else
		echo "bbwarnsetup.cfg: No value is set for the pagedelay token: 15 minutes will be used"
	fi
else
	echo "bbwarnsetup.cfg: The pagedelay token has not been defined: 15 minutes will be used"
fi

PAGELEVELS=""
pagelevelsline=`grep "^pagelevels:" $BBHOME/etc/bbwarnsetup.cfg` 2>/dev/null
if [ "$?" -eq 0 ]
then
        set $pagelevelsline >/dev/null 2>&1
        if [ "$#" -gt 1 ]
        then
                shift           # remove pagelevels token from line
                param="$*"

                # Check if it's a valid parameter, remove bad values

                for color in $param
                do
                        case $color in

                        yellow | red | purple )
				PAGELEVELS="$PAGELEVELS $color"
                                ;;

                        * )
				echo "bbwarnsetup.cfg: The value \"$color\" is invalid for the pagelevels token"
                                ;;

                        esac
                done
	else
		echo "bbwarnsetup.cfg: No value is set for the pagelevels token: \"red purple\" will be used"
        fi
else
	echo "bbwarnsetup.cfg: No pagelevels token has been defined: \"red purple\" will be used"
fi


PAGELEVELSMAIL=""
pageslevelsmailline=`grep "^pagelevelsmail:" $BBHOME/etc/bbwarnsetup.cfg` 2>/dev/null
if [ "$?" -eq 0 ]
then
        set $pagelevelsmailline >/dev/null 2>&1
        if [ "$#" -gt 1 ] 
        then
                shift           # remove pagelevelsmail token from line
                param="$*"

                # Check if it's a valid parameter, remove bad values

                for color in $param
                do
                        case $color in
  
                        yellow | red | purple )
				PAGELEVELSMAIL="$PAGELEVELSMAIL $color"
                                ;;

                        * )
				echo "bbwarnsetup.cfg: The value \"$color\" is invalid for the pagelevelsmail token"
                                ;;

                        esac
                done
        fi
fi

for color in $PAGELEVELSMAIL
do
	echo "$PAGELEVELS" | grep $color >/dev/null 2>&1
	if [ "$?" -ne 0 ]
	then
		echo "bbwarnsetup.cfg: 	The value \"$color\" specified in the pagelevelsmail token"
		echo "			is not defined in the pagelevels token, it will be ignored"
	fi
done

pagetypeline=`grep "^pagetype:" $BBHOME/etc/bbwarnsetup.cfg` 2>/dev/null
if [ "$?" -eq 0 ]
then  
        set $pagetypeline >/dev/null 2>&1
        if [ "$#" -gt 1 ]
        then
                shift           # remove pagertype token from line
                param="$1"

                # Check if it's a valid parameter,
                # Set it if it's valid

                case $param in

                RCPT | GROUP | HOST | EVENT )
                        ;;
                * )
			echo "bbwarnsetup.cfg: The pagetype token is invalid - \"$param"\"
                        ;;
                esac
	else
		echo "bbwarnsetup.cfg: The pagetype token has no value assigned"
		echo "				RCPT based notification will be used"
        fi
else
	echo "bbwarnsetup.cfg: The pagetype token has not been defined"
	echo "				RCPT based notification will be used"
fi


cfgdelimline=`grep "^cfgdelim:" $BBHOME/etc/bbwarnsetup.cfg` 2>/dev/null
if [ "$?" -eq 0 ]
then 
    set $cfgdelimline >/dev/null 2>&1
    if [ "$#" -gt 1 ]
    then 
            shift           # remove cfgdelim token from line
	    case $1 in
	    ',' | ':' | '/' | '*' | '.' )
		echo "bbwarnsetup.cfg: The cfgdelim token is invalid: \"$1\""
		;;
	    * )
		;;
	    esac
    else
	echo "bbwarnsetup.cfg: The cfgdelim token has no value associated with it"
#	echo "				\";\" will be used"
    fi
else
	echo "bbwarnsetup.cfg: The cfgdelim token has not been defined"
#	echo "				\";\" will be used"
fi


else
	echo "bbwarnsetup.cfg: This configuration file does not exist !"
fi

exit 0
