{
    This file is the source for a series of routines that detect the type
    of video adapter in a system.
    Copyright (C) 1998 by Phil Brutsche

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the
    Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA  02111-1307  USA.
}

unit video;

interface

type
  cardtype = (none, mda, cga, egamono, egacolor, pga,
              vgamono, vgacolor, mcgadigcolor, mcgamono, mcgacolor);

type
  VESAInfo = record
    name : array [1..4] of char;
    version : word;
    oemname : longint;
    capabilities : longint;
    modes_supported : longint;
    memory : word;
    arry : array [1..492] of char;
  end;
  VESA_mode_info = record
    mode_attributes : word;
    window_a_attributes : byte;
    window_b_attributes : byte;
    window_granularity : word;
    window_size : word;
    window_a_start_seg : word;
    window_b_start_seg : word;
    window_posit_func : longint;
    bytes_per_scanline : word;
    width : word;
    height : word;
    char_cell_width : byte;
    char_cell_height : byte;
    number_mem_planes : byte;
    bits_per_pixel : byte;
    number_banks : byte;
    memory_model : byte;
    size_of_bank : byte;
    number_image_pages : byte;
    reserved0 : byte;
    red_mask_size : byte;
    red_field_posit : byte;
    green_mask_size : byte;
    green_field_posit : byte;
    blue_mask_size : byte;
    blue_field_posit : byte;
    reserved1 : byte;
    direct_color_info : byte;
    linear_buffer_address : longint;
    ptr_to_offscreen_memory : longint;
    size_offscreen_memory : word;
    reserved2 : array [1..206] of char;
  end;

const
  cardtypestrings : array [0..10] of pchar = (
    'Text only', 'MDA', 'CGA', 'EGA mono', 'EGA color', 'PGA', 'VGA mono',
    'VGA color', 'MCGA digital color', 'MCGA mono', 'MCGA analog color' );

function videocard : cardtype;
function vesa_detect (var info : vesainfo) : boolean;
function vesa_get_mode_info (mode : word; var info : vesa_mode_info) : boolean;

implementation

uses dos;

function videocard : cardtype;
var
  regs : registers;
begin
  regs.ax := $1a00;
  intr ($10, regs);
  if (regs.al = $1a) then begin { successful }
    case regs.bl of
      $00 : videocard := none;
      $01 : videocard := mda;
      $02 : videocard := cga;
      { $03 is a reserved value }
      $04 : videocard := egacolor;
      $05 : videocard := egamono;
      $06 : videocard := pga;
      $07 : videocard := vgamono;
      $08 : videocard := vgacolor;
      { $09 is a reserved value }
      $0a : videocard := mcgadigcolor;
      $0b : videocard := mcgamono;
      $0c : videocard := mcgacolor;
    end;
  end;
end;

function vesa_detect (var info : vesainfo) : boolean;
var
  infoseg, infoofs : word;
  result : byte;
begin
  info.name := 'VBE2';
  infoseg := seg (info);
  infoofs := ofs (info);
  asm
    mov ax, $4f00
    mov es, infoseg
    mov di, infoofs
    int $10
    mov result, ah
  end;
  if result = 0 then
    vesa_detect := true
  else
    vesa_detect := false;
end;

function vesa_get_mode_info (mode : word; var info : vesa_mode_info) : boolean;
var
  status, infoseg, infoofs : word;
begin
  infoseg := seg (info);
  infoofs := ofs (info);
  if mode <> $FFFF then begin
    asm
      mov ax, $4F01
      mov cx, mode
      mov es, infoseg
      mov di, infoofs
      int $10
      mov status, ax
    end;
    vesa_get_mode_info := true;
  end else begin
    vesa_get_mode_info := false;
    exit;
  end;
end;

end.
