#ifndef FAT_H_
#define FAT_H_

#include "..\..\engine\header\rdwrsect.h"

#define FAT12 12
#define FAT16 16

/* FAT labels for FAT12. */
#define FAT12_FREE_LABEL     0x000
#define FAT12_BAD_LABEL      0xff7

#define FAT12_FREE(x)     (x == FAT12_FREE_LABEL)
#define FAT12_BAD(x)      (x == FAT12_BAD_LABEL)
#define FAT12_RESERVED(x) ((x >= 0xff0) && (x <= 0xff6))
#define FAT12_LAST(x)     ((x >= 0xff8) && (x <= 0xfff))
#define FAT12_NORMAL(x)   ((x != 0) && (x < 0xff0))

/* FAT labels for FAT16. */
#define FAT16_FREE_LABEL     0x0000
#define FAT16_BAD_LABEL      0xfff7

#define FAT16_FREE(x)     (x == FAT16_FREE_LABEL)
#define FAT16_BAD(x)      (x == FAT16_BAD_LABEL)
#define FAT16_RESERVED(x) ((x >= 0xfff0) && (x <= 0xfff6))
#define FAT16_LAST(x)     ((x >= 0xfff8) && (x <= 0xffff))
#define FAT16_NORMAL(x)   ((x != 0) && (x < 0xfff0))

/* Generalised FAT labels. */
#define FAT_FREE_LABEL       0x0000
#define FAT_BAD_LABEL        0xfff7
#define FAT_RESERVED_LABEL   0xfff0
#define FAT_LAST_LABEL       0xfff8

#define FAT_FREE(x)     (x == FAT_FREE_LABEL)
#define FAT_BAD(x)      (x == FAT_BAD_LABEL)
#define FAT_RESERVED(x) ((x >= 0xfff0) && (x <= 0xfff6))
#define FAT_LAST(x)     ((x >= 0xfff8) && (x <= 0xffff))
#define FAT_NORMAL(x)   ((x != 0) && (x < 0xfff0))

typedef unsigned CLUSTER;

int GetFatStart(RDWRHandle handle);
int GetFatLabelSize(RDWRHandle handle);

SECTOR ConvertToDataSector(RDWRHandle handle,
                           CLUSTER fatcluster);

int LinearTraverseFat(RDWRHandle handle,
                      int (*func) (RDWRHandle handle,
                                   CLUSTER label,
                                   SECTOR  datasector,
                                   void** structure),
                      void** structure);

int FileTraverseFat(RDWRHandle handle, CLUSTER startcluster,
                    int (*func) (RDWRHandle handle,
                                 CLUSTER label,
                                 SECTOR  datasector,
                                 void** structure),
                    void** structure);

int ReadFatLabel(RDWRHandle handle, CLUSTER labelnr,
                 CLUSTER* label);

int WriteFatLabel(RDWRHandle handle, CLUSTER labelnr,
                  CLUSTER label);

unsigned long GetBytesInFat(RDWRHandle handle);

CLUSTER DataSectorToCluster(RDWRHandle handle, SECTOR sector);

#endif

