; LBAcache - a hard disk cache based on XMS, 386 only,
; and aware of the 64bit LBA BIOS Int 13 Extensions.
; GPL 2 software by Eric Auer <eric@coli.uni-sb.de> 2001

; Check out the CHS version as well (limited to 8 GB,
; uses less DOS memory, and wimps out on LBA write)...

; include the SYS header, SYS basics and global data

;        assume  cs:dat,ds:dat,es:dat

next	dw -1,-1
attrib	dw 1000000000000100b	; very simple NUL device
stra	dw strat	; strategy  -> prepare, save ES:BX pointer
inr	dw intr		; interrupt -> main procedure
nam	db 'HDCACHE$'	; our name, WARNING: becomes invalid file
			; name, this is why the "$" is included
			; ("HDCACHE$.*" being invalid is less annoying)

; ---------------------------------------------------------------

; All the stuff up to and including TSRSIZE must not change in
; structure, because external tools rely on this data being there!
; The magic values are the name at offset 0x0a and the xms handle
; right after that being HDCACHE$ and not-zero respectively. 

xmshandle
	dw 0		; our XMS handle (also for unloading)

pb	dd 0		; buffer for the ES:BX pointer...

xmsvec	dd 0		; call far pointer for XMS services

geometry
	db 63,255	; for the hard disks 0x80 .. 0x83:
	db 63,255	;   first byte is max sector number,
	db 63,255	;   second byte is max head number
	db 63,255

rdhit	dd 0	; those 4 counters offer some statistics
rdmiss	dd 0
wrhit	dd 0
wrmiss	dd 0

hint	dw table	; pointer to table (hint for debuggers)
tabsz	dw 8	; hint for debuggers: size of table entries
		; high byte is how far sectors must be shifted right
		; to get number of table entries!

sectors	dw 4096		; how many sectors to cache (512 bytes
			; XMS and {4 bytes CHS / 8 bytes LBA version}
			; DOS RAM for each sector) (also for debuggers)
			; NEW binsel.27.11.2001 uses only 8 bytes for
			; each 1<<N sectors, e.g. for 4 sectors :-)

oldvec	dd 0		; the old INT 0x13 VECTOR (also for unloading)


running	dw 0		; 1 means "init already done"
			; 2 means "disabled" (for the dispatcher)

tsrsize	dw eoftsr	; to know what has to stay in RAM

; ---------------------------------------------------------------

havelba	dw 0		; 1 means LBA BIOS found, 0 means CHS only
			; *** not handled in rwfunc yet,
			; *** but initialized correctly!

; ---------------------------------------------------------------

.8086
strat:	; in theory, we could even copy the data at es:bx here
	mov word [cs:pb+2],es
	mov word [cs:pb],bx
	RETF


intr:		
	pushf
        push bx
        push es
        les bx,[cs:pb]
        mov byte [es:bx+0x17],0		; no error
        and word [es:bx+3],0x7ffd	; not busy / no error
        or word [es:bx+3],1		; ack status
        cmp byte [es:bx+2],0	; is the command INIT ?
	jnz nix
	cmp byte [cs:running],0	; install already done?
	jnz nix			; only allow init once
        jmp install
nix:    pop es
        pop bx
        popf
        RETF

int13new:
	test word [cs:running],1
	jz int13off			; handler disabled?
	jmp NEWI13			; the dispatcher (386 code...)
int13off:
	jmp far [cs:oldvec]		; chain to old handler

	; all stuff up to this line has to stay in RAM in case we were
	; loaded as SYS or in case int 13 was changed in the meantime!

eoftsr:	; just a label to know where the important part ends
