#include "control.h"
#include "controls.h"
#include "vscrctrl.h"
#include "loview.h"
#include "..\scandisk.h"

static void FillViewer(struct Control* control)
{
   struct VerticalScrollControl* VBox = 
                         (struct VerticalScrollControl*)control->ControlData;

   struct LowView* view = (struct LowView*) VBox->ControlData;

   view->FillControl(control, 0);
}

static void OneDown(struct Control* control)
{
   struct VerticalScrollControl* VBox = 
                         (struct VerticalScrollControl*)control->ControlData;

   struct LowView* view = (struct LowView*) VBox->ControlData;

   if (!view->PastTop(control, view->top+1))
      view->FillControl(control, ++view->top);

}

static void OneUp(struct Control* control)
{
   struct VerticalScrollControl* VBox =
                         (struct VerticalScrollControl*)control->ControlData;

   struct LowView* view = (struct LowView*) VBox->ControlData;

   if (view->top > 0)
      view->FillControl(control, --view->top);
}

static void EntryChosen(struct Control* control, int index)
{
    control=control,index=index;
}

static void OnEntering(struct Control* control)
{
    control=control;
}

static void OnLeaving(struct Control* control)
{
    control=control;
}

struct Control CreateLowView(struct LowView* view,
                             struct VerticalScrollControl* VBox,
                             int posx, int posy,
                             int forcolor, int backcolor)
{
   struct Control result;

   result = CreateVScrollBox(VBox, posx, posy, forcolor, backcolor);

   VBox->ControlData = (void*) view;
   
   VBox->AnswersEvents = TRUE;

   VBox->OneUp       = OneUp;
   VBox->OneDown     = OneDown;
   VBox->EntryChosen = EntryChosen;
   VBox->DrawControl = FillViewer;
   VBox->OnEntering  = OnEntering;
   VBox->OnLeaving   = OnLeaving;

   view->top = 0;

   return result;
}
