#ifndef _h_UTIL_STAMP_
#define _h_UTIL_STAMP_

#ifdef ASM86
# include <cv/asm86.h>
#endif
#include <cv/cpphelp.h>
#include <cv/dos.h>
#include <cv/trace.h>


enum RETCODE {	RET_SUCCESS	= 0,
		RET_NONCOMPARE	= 1,
		RET_IOERR	= 2,
		RET_BADOPT	= 128,
		RET_BADARG	= 129,
		RET_INTERNAL	= 130 };


enum ACT { CHANGE, LESSER, EQUAL, GREATER };

struct DATE { byte day, month; count year; };
struct TIME { count second; byte minute, hour; };


bool FAST_	fileref(CStr);
void		sayerror(CStr when, CVP what, size_t);
void FAST_	sayerror(CStr, CStr);


//---------------------------------------------------------
#ifdef STD
#define assigndt(l, r) { (l).day = (r).day;		\
			 (l).month = (r).month;		\
			 (l).year = (r).year; }
#else
#define assigndt(l, r)	((l) = *(DATE*)&(r))
#endif
#define assigntm(l, r) { (l).hour = (r).hour;		\
			 (l).minute = (r).minute;	\
			 (l).second = (r).second; }

//---------------------------------------------------------
#ifdef ASM86

#define packtime(t, ts)	{ _DX = *(word*)&((ts).minute); _AX = (ts).second; \
			  _DL <<= 2; _AX >>= 1; _DX <<= 3;		\
			  _AX |= _DX; (t) = _AX; }
#define packdate(d, ds)	{ _AX = (ds).year; _DX = *(word*)&((ds).day);	\
			  _AX -= 1980; _DL <<= 3; _AX <<= 9; _DX >>= 3;	\
			  _AX |= _DX; (d) = _AX; }
#define unpacktime(ft, ts)	{ _DX = _AX = (ft); _AX &= 0x1f;	\
				  _DX >>= 3; _AX <<= 1;			\
				  _DL >>= 2; (ts).second = _AX;		\
				  *(word*)&((ts).minute) = _DX; }
#define unpackdate(fd, ds)	{ _DX = (fd); _AH = _DH; _DH &= 1;	\
				  _AX >>= 9; _DX <<= 3; _AX += 1980;	\
				  _DL >>= 3; (ds).year = _AX;		\
				  *(word*)&((ds).day) = _DX; }

#else

#define packtime(t, ts)	((t) =	( ((ts).second >> 1)		\
				| ((ts).hour << 11)		\
				| ((ts).minute << 5)))
#define packdate(d, ds) ((d) =	( (((ds).year - 1980) << 9)	\
				| (ds).day			\
				| ((ds).month << 5)))
#define unpacktime(ft, ts)	{ (ts).second = ((ft) << 1) & 0x3f;	\
				  (ts).minute = ((ft) >> 5) & 0x3f;	\
				  (ts).hour = unsigned(ft) >> 11; }
#define unpackdate(fd, ds)	{ (ds).day = (fd) & 0x1f;		\
				  (ds).month = ((fd) >> 5) & 0x0f;	\
				  (ds).year = (unsigned(fd) >> 9) + 1980; }

#endif

//---------------------------------------------------------
#ifdef ASM86

#define DATECMP(ret, l, r)						  \
		{ ret = GREATER; if(*(dword*)&(l) <= *(dword*)&(r)){	  \
		  ret = LESSER;  if(isFLAG(Equal)) ret += EQUAL - LESSER; \
		} }
#define TIMECMP(ret, l, r) DATECMP(ret, l, r)

#else

#define DATECMP(ret, l, r)						    \
		{ ret = EQUAL;						    \
		  if(*(dword*)&(l) > *(dword*)&(r)) ret += GREATER - EQUAL; \
		  if(*(dword*)&(l) < *(dword*)&(r)) ret -= EQUAL - LESSER;  \
		}
#define TIMECMP(ret, l, r) DATECMP(ret, l, r)

#endif

#endif /* _h_UTIL_STAMP_ */
