discard """
targets: "c cpp js"
"""

import checksums/bcrypt
import std/[assertions]

const
  # In case the test turns out to take too much time, this factor can be turned down.
  roundLimit = 10

  # Python test hashes, generated via:
  #  for n in range(5,50):
  #   for i in range(5):
  #     pw = ''.join(random.choices(string.ascii_uppercase + string.ascii_lowercase + string.digits + "_-/()", k=n))
  #     print(f'("{bcrypt.hashpw(pw.encode(), bcrypt.gensalt(rounds=i+7)).decode()}", "{pw}"),')
  testHashes = [
    ("$2b$07$z4keq/YQPaN42hs5uVDGEecvwWkZ1zCVnRHoUFx74hXwv37SkYvtG", "74IsK"),
    ("$2b$08$pypsbaqPf/vuifm8AFMf2uEQGjiFchgk0kE2uAxYXhuq3SX17C5tq", "XX(Zg"),
    ("$2b$09$TE0SL1VuNr/leTC7NkJ5U.FZRQmGCGVu1V/RIkvKdsURiQDLd0dne", "F_tQz"),
    ("$2b$10$zmYs7ubfhA8NVWRHV085x.TsaZmXRreHtKv4g89.i8pUYgXJY4FxO", "in5fQ"),
    ("$2b$11$KGL5MxCldvBvrKFSQ.LGeOo4kyYTnB4w.3ZhrgwTNXgBbygHSjj5e", "y3WJ5"),
    ("$2b$07$m1E789lZZXjd83I/V00NROBXVh34fGsGUj4zePuUquKzivhLQ/5Km", "ECNsY7"),
    ("$2b$08$TZYY54dPNhkdbM7QfNUkXepIx7ggzuI.E15w7fnr4BVYBko..QIhu", "(7FHEN"),
    ("$2b$09$09pHm9.jSlYcO.WtyVfHm.7iuX63ifxi3DiOwXK/xx9uVARuVouo6", "QsNDgz"),
    ("$2b$10$IqLM0Hn6g87h8nYLA3wIFuioQvQHwrLlotAJ7tVz85rB8jPioO9DS", "TknuDz"),
    ("$2b$11$aqbvjdwonTMiNOKYiWwAz.M2dB6Op.Q0NaVE7nBE0IEujmYNQoXX2", "KBg)PV"),
    ("$2b$07$LrTnI8jyVIrSksTnRBlGU.fR.vJtonuqgiiDoRuNlHRc6WH9nbhDS", "5T)-p/W"),
    ("$2b$08$/GzGtw3Xd3mOcQW/fg3gqeCyi8PnUYLSmLGeJi/RjnPEOPRukVTpy", "qRXuGb)"),
    ("$2b$09$5i4uj09bFNxNY4UqPaWwreIXuyx03UCVFhzbjt1a4FBO4upQT8siO", "VN0NevE"),
    ("$2b$10$BWDwU156lJ9NfMq4LaFsFuCAngImJ5yYBlwvThhtKUu5a7byGYlbK", "48atT7N"),
    ("$2b$11$iyd7f4XBxzKR6ptF4LZpL.U0SaENGaB4ALws6fdJxCwpLSVSRxYoy", "Y/1xhkS"),
    ("$2b$07$EIqB85qw6csGu3nrpyNVZuQFJ7OtdaWSkmXolFu3R3JEkwfEH.pkG", "9hG13(oN"),
    ("$2b$08$gIxUqLbcwoUHRluGO5sKiO1cFjECahUA0m8pzjdwcna2LjrXMyEoS", "aW-BgfPd"),
    ("$2b$09$/qXaYoVqv0q/jvKhWFtmWOuW9/q9eQ2YrBEaFMEj4EJweuazzdgG.", "lOj2viqq"),
    ("$2b$10$4BQ2I1l3kldlH/BlO9WFb.F9U4ydOBv78p2.B6LMw8nWoLAJB7sOK", "sumt1XC/"),
    ("$2b$11$twLSi4PJQJCedfT7Y1f/c.LG7ToL.7wbBnGpC0CULO/ubXUSjV6SW", "iVJN48I0"),
    ("$2b$07$GPI8JvgABcnbhXzJPEJe7uw8r/zj4jpzB36uLc95uFHczgOwzSW3C", "yt9MSFhja"),
    ("$2b$08$BUaxjCYG5cocwFT30vHAaumdgW8GB0IZrR5Yl7SOek12BYN5k3SWG", "txE(1TOPz"),
    ("$2b$09$/.q0H7p46GWZ/LidmlIbQe9TktT8y0T06ncQFQh6w6Cl3gI16lKqm", "4kKlvnirX"),
    ("$2b$10$Zj.O6vB1C124FC3XBx5KeOR17IHr4jYwkOfCVz2vyUzOBcDQ6PqHK", "9f)PZsQOJ"),
    ("$2b$11$kSlH7h9wUZxefLqtkfnas.Ygqbw/Ky05EVdwK3NwVZMCLJBX5nuKq", "x1tK/Lahn"),
    ("$2b$07$yaAhA5PHSong9WwDt08t3OnwLAcOHGxgkrIWq1kwqbeS4hqqsLeZS", "(m5oaZAaub"),
    ("$2b$08$qSXwzSbre4RibQ0lL/uiiuHQtyEf.S0jVflsPatJNXM6w.UCDaGz2", "lON_sEZo4x"),
    ("$2b$09$LA7Rc/wDN8XQxvlojA.rGe8yslrwhjjUM7wWv/JwdANCK30df2Asm", "3deP(otBsE"),
    ("$2b$10$Xl2oL6W1viAq8fc.xfHPguehgqeWnwByV5SKg7wdjxTCXVG19Vlwq", "NhGPxP_3Cr"),
    ("$2b$11$RnTMyy9exol4lKwVd/XNaO6sGvkmClXKIgRR.0e/le34otfV9IiaK", "XxD-9Zxhs/"),
    ("$2b$07$2TWgg1l60cI0MTEsmFuJzu4HtsB5ARak6IhI22mzphawsVEGd2/my", "8cXD3lbwB)E"),
    ("$2b$08$kV32SqVUaYauE.hJqyb/9O6CG8ZLuWoBC1SpJdWOq1q5kBf2dfbsG", "pF9ubm89VMX"),
    ("$2b$09$PZna.oDY7atmQNFrFDmYWe4JlAcJFoA1wTFWM4H435nyT/UqJ.wYW", "3v3YSvQPA)g"),
    ("$2b$10$DWe2LBFXdrRIz2xxAQspiOm4qDz7Lcy.mCVAfRZWEhJkfSz9S/aj6", "t/AmyeoPBv("),
    ("$2b$11$txZttraVdVlSLkVYsvU71eiTfYtocazKCeeEmLG1VgE58zQ.gr0kS", "H5m)_he36CM"),
    ("$2b$07$/BZAQ3UiG0zG1C/HJ7fqlulPgMFWT9pUDY.a8TuRkfZ.D7cjOwJ92", "vnKr/m0u2/y4"),
    ("$2b$08$QFteWKxXARwzW7hjrfwbzePyt/nSam7C8.rZdGQwkBxe5VTpoPmMG", "OHVOl-Jf0fAx"),
    ("$2b$09$goRiKwSGx2c1lNG6UN98G.c3F0zV203XlgDGwJiEs8tJYriez4Hbu", "cnvy0lvoUdm5"),
    ("$2b$10$9WyZGp6Qs8LTZDQaN1fIW.KrCmm0OfZ3dr3TSZVT83UeFpIaghJsK", "Xj)0F8jj9fp4"),
    ("$2b$11$16hpUrxyPj5PZ9yERfpI7uGS4rFn8OWBzc5BZl4qc6zKowG0Hx5DC", "TDnqE95NZNyf"),
    ("$2b$07$xvL0D/bQmK7CJDj34qYEc.vZlxEsJTjurJLUsdqQuiXrusSrKXgaS", "hZUtu4B6vbwwt"),
    ("$2b$08$PELSBKIHc6V2A/TJ36YLleS.EoFD2pnHDDCydavNJrv4/r.nHKWG2", "Bd-UlJISzBLyw"),
    ("$2b$09$P.on5YaIxBAMZxKTJmmbJeZrRapdAnhcKvQYOqSNuRPSPm.gEESAm", "a7qvppgCaCW-X"),
    ("$2b$10$cvD2anGV/svoUBmpKsELaO46OcSKN13VQUsSQFwkKOT4ZWTuSkfPi", "FLNfIJpAFSEji"),
    ("$2b$11$L2OKuYIasjiLEBTNB4AnOOlMM0CP4GSOVrIsjeeVHaANtD2snFXmq", "C3gmQ5uy3-L-6"),
    ("$2b$07$opt7Zss2XYrmE.FLONdFdurA6T6S.l4x15Wp0eL.zJSP7VkmuTvgq", "vHq9kzF())It(8"),
    ("$2b$08$qBhKGFbNzmxEDLCc7k/dk.2scKSwibF5jkn7b4CWh9jr0wR32hrEC", "erjtPw1TPGzMZJ"),
    ("$2b$09$UCHvGBDQQqxADJk4titI0.V5THbW47Ckb6XB7omRk5A1SJv/onk5G", "c_E)zi0fFM-B5e"),
    ("$2b$10$CHje51O.lD6FKZGkc5lHJOgHzZrSCjRvqEQ.6FvAKn/57Ia.CTIwm", "3s1mnWqXxisaIp"),
    ("$2b$11$0yD1egGCzB7OJa5Eag/8y.aHG3wQV97n5mwnXkfZZbawiifV/nkP2", "1TA)fspL6nMJYg"),
    ("$2b$07$RC4BEN4VZhGMfpIMD7uMdO2/HFl4Ui8CSXe4wBZt.U79LMSEbuDka", "lZ4sxnwGpcvifIo"),
    ("$2b$08$J5UM5mPZnz/SjPPCB2n5DOkcHChPLrlGlccKLz3OwV01bfj.h4f2K", "bENIPca-ZGw9k68"),
    ("$2b$09$QVY7iRvmlAnUAXqq0skC.uH2j9kkCftg5G5NmaT2eQ0T6X53OEG1q", "_UyXZQnLn7bD_g0"),
    ("$2b$10$kSls8C/jItA3a8a2ZAqPSuDNxLoP2N0CT6LAVqjjw83CVgNIoTVY.", "oD)GZZfHXDs_04-"),
    ("$2b$11$hrcHDhUWa4.H31hI7rEMfO1ExmVXhsV6gQMWf34tNWJr6b/yFvHi.", "W47ucd-wMgxbrbP"),
    ("$2b$07$U0RSXqT9AgC3AfgJs9aKzOb0qbrFRx/PQfMjaUav9iuYTPMTTZWZK", "sw9SAQ0fz5hhhuLr"),
    ("$2b$08$dw0KbRGI4NzTSH5CTGTlfeDqapf3Wr.Z7FPgKkWNtgJTpDsSQFB3i", "WO3mYcLwDWU7AzTM"),
    ("$2b$09$J6xYJS0H9sAXQkjYYFepmOOl4EYcLfJNAp/lYPNggho5L2Z3uKDxC", "eZ6WoDh62ZNdKQ6e"),
    ("$2b$10$D/KxaLiJbxvgAwGKA.GWZOndDeg1TdKqq2lTF18kFlH4uJwue6.Yi", "3rfkfN51//6T(YUC"),
    ("$2b$11$aLxGU/9jX.flrXr5ECWH1O1DxnxEspvINVUM/Z44QwSbxm2cJJKHm", "RSKQ7bnutK7Q-Mpv"),
    ("$2b$07$0ltZfNanmcE5P7v0/R/RK..hLK1jRw55j/w8WZgLQ8WOe.Wwh.K6q", "fBXDLbLa)jyeYp_ee"),
    ("$2b$08$iwHP/LfLBHNiasEgndfk4eOiLFtIMECGZTrJp3z8k8SF8nt/WUJli", "jfKi4NouMCLPBmckJ"),
    ("$2b$09$nHMuI91/yoZy9a14ui13gO.J.LFDzPoWS8BrAerg2MfxV3WuTI86C", "f)gM)jTgJNtGorBeS"),
    ("$2b$10$KTnWc7ltASnkZyl.f8svyuFxqSMcYCYSQoj32IQmXuFFWe4m6NRW.", "(f9M52pqMDvpyyBtu"),
    ("$2b$11$h.r4eRZ5zazwtDldaQpanOWmCtmXLzQ2MInlbaS8IRJ0OgffCRuLO", "KTaW7nh0ysT4UpdpO"),
    ("$2b$07$pe2kXUfaSY6nKxXaURll9e66X5/USmn8G2QLoPiI4cTv/cyEbLiia", "sUAJeD-T2zddfHRa8i"),
    ("$2b$08$pWt5AFIZnHPnsUY2mCtuL.ad/mIiotqjTJOKcYyLKULakUKxyXEha", "-9RMB6ULECTiDOfr2-"),
    ("$2b$09$Xu849ZAvBU5eXfSKESDiWeLlVcCPp/VSC21uVRG4Ezsct6b7iapWG", "6wqIFtAyWmk)z77D9J"),
    ("$2b$10$eibo5fdX8l2wHMMHDSM4TOkZ3jV7B5Mf3XWXMEYaq54YA/NJekJ8G", "B5PqeKZohE56YBEBrr"),
    ("$2b$11$Z52Gh27K8gcl6KfEP32LAOp4ALF.TQEKpVSVzFJ1lrle3wzcHhoJC", "sglm(lnZx-y8yOhKvT"),
    ("$2b$07$1wftKAaZWexv4M0VMvbwS.gtowphSy4KnW/yEDrUF.6qp6og4NIS2", "k9bBcJCXumIb4Ii34n)"),
    ("$2b$08$vGuacHEDgZezBmf7qYZe1elpXRWnx06E96RGwmlRFz8syKIzdpbmi", "dxzAFfutslS24kt8a)a"),
    ("$2b$09$/twFr557PB4bFX5NmFkwVeLujj1mR.O3uXfzEI83lG30xYrJbfBEy", "N1NX))W-VO)LIWKa(/J"),
    ("$2b$10$SYma1XHxRV2HnK4MlRzoROalcOWxjKV9wvb2aMeI2eYWO3AqXMJYq", "GCfBW7bqGPzbOq/52Ub"),
    ("$2b$11$ax0Hc0SinaQgaTU68ADQduFPvIq4F1r8mnL4kFfdk11KA.Ti29jiW", "aY(l/k37TpFs2klVwVe"),
    ("$2b$07$XlQGYVkgkcrf8ai7I1C.VecS0jutqCGnZjttj4EvVVE1xAad/6NYC", "CqtKAsItW/yWLKPMqIN7"),
    ("$2b$08$bwr3j/SygYeEDZja/xDpX.bEIH3HPHHKgNeScwDwJ0Nq6dXoMl7YO", "m85R)A_pGg3KSuFTLS9H"),
    ("$2b$09$1c52NkDK1ZGArFgRvywQo.NjgYPNVTfLMK5nd/gVRl3nGH9FZ6to2", "kI1BydLBmXlRM9fRjc4s"),
    ("$2b$10$nQ6dYvdU6tvoUVzUdmtWR.JrbUZSJ2dCcusp5XGZ7kTO6LggMXerq", "C_QtQnUj7K0uybMvsEXJ"),
    ("$2b$11$.UpRqOcbRWQTzWpzIAPBueYXJE27FBZgbcvyxALqucft524LZ2weu", "FFmsn5yUtvw4Ker)0ZDh"),
    ("$2b$07$Nu3lylk5NGLMegZ.WUWL1.NCNbz6B0Z7QSjvRnm4tS0U9pXrHJbVG", "l)(Nj//8M-yLuQnUYC_NP"),
    ("$2b$08$FnRBC0fgnhduTpFAR2Ed9OsnFKl6qsUyloybAqznfx85K3d3rwVg.", "nlaF53whT1_I43TS08(kt"),
    ("$2b$09$TGcFBNgc85yz2oBrM2xYyeUtfe7b4ZM8WdRqRe3S3ilPS0Ic0mq26", "ArOTeP-1Y0UZ9o2JcyK)n"),
    ("$2b$10$CrIEMYXBSQULJqbEraIy7OEHsr6L0nDrIGIcYkUZ/CbogHBLd7DFW", "NcdIgVRdECBD4QA7fqfco"),
    ("$2b$11$0PMes..HMMO8UdT0KKumb.9Ge8RwvdTE9bvGUtaOZtNG2dIZ2HPY2", "eknI/76vG9iS)irG8FUau"),
    ("$2b$07$EEdV0O9SC.tvhvIsLeyT5.JUylGn8Maum1vr.k17QkAoTUjHgeaWW", "to7jM-3zdLvRAS5E(aI9t9"),
    ("$2b$08$bYH5QlT6yrJAdgE8vd/3T.ZlXlys0siDNPw8M5Z2QwzLAbnaCmt6.", "hF6gV/L5j_w8KjzwQNNcc4"),
    ("$2b$09$hD4fBLwH.ayP6o2OJ7q.i.hcXjkYFgwLtW2tysFf.j7e.cpe9Nzgm", "reh-4TjmkZSQk-ovZ)a()f"),
    ("$2b$10$VKdCl77.uzHXFPscZqKALe8eQ9zYv.Cqxkr6k7xxfu/tOvrDwyx5e", "XZmkG8zPQv2c33-UJKeJHG"),
    ("$2b$11$PgL6OxI0.reGW1LXdgQrguBaPR9.pNR7JrVLS4R3hnpgin9dgL/zq", "dqeh-HBRQjVUeMKYbX8Y/Z"),
    ("$2b$07$VvEnyn4XfU5WLJVwhW.BqefVstVptedeG10GOjf4n2t9ih251WD5W", "0vy/EIQjlbq2PE8h7FFcLMv"),
    ("$2b$08$5tmFRFWaiFyY1IF59ofDxOofE5/WLMdXdE0XUliPW.feUBnYeFgDG", "c50tiO3Q9Lh(D5wqF8bawdO"),
    ("$2b$09$gXFCUFQVeWXwO.RM4Hfm7.YOhKI.dgrKoCxuUcAMptbfEQl2pCIim", ")i9c3vLPbKv5M/gjSbLp6_V"),
    ("$2b$10$QndLH/gCqMHwnTzcnnm1fuqh.eKGAgsm4OWicbxwTYRhrUARLhz.G", "tSypCW/duLwe3elYa1H0Rsl"),
    ("$2b$11$Bm2ZqVp5kWbDoIl.rIBFZeEJdb69.ayC6oYLLtwZ9eEd0bTba1Pm2", "(1i4k23Es2MK7Y4GalUwl1J"),
    ("$2b$07$EerRfRkw7xy8iUKg0T.qLe4OpEzMdwUYESTjHcw6Ex8OIMwpGQcCS", "r53(axgXkj0Obk3J/G/HbI)Y"),
    ("$2b$08$M5FS6u5e3vEQHpFt727rEeg2hMUl.rcjQSQgR.aPW26/4wZCiaXES", "PJzUU_aUKOth1SADTgwQ7gy("),
    ("$2b$09$QNSTbQ4fNiPBBHx.1wCyGuRo8F26m1jJtOIQchbTUYK1u02D7dpwK", "-z(3IuvCDDofE6KNi)xeD5WZ"),
    ("$2b$10$yiSKAgeRP9uVMIlMvrVpZeA4JliNGDDj8RVeWApP9Kvje5mafOy4e", "3vpqG-AGvP-B(_NA2_)L9UFR"),
    ("$2b$11$Uqu/EHNf/ZqCIHh97pb5X.kfmGJp61hMtt3tu.D.XUTc.5DB7S1kW", "OVCQF82zNgGlHn2e7fYmfCgd"),
    ("$2b$07$q0NvegzC8OwG4AK47MncVO0Rp4.rZc/iopJvu4oJkWGFbkTswNSCy", "Sr6iV2qdQG4lqQo)4u13ndg4G"),
    ("$2b$08$jA8RLJkm0UXbfNSJorl67ebQ3hE.GokF2ytJhgHh16zHzHX8rjDQ6", "Mzncyx(cMW6)k4lwk7g)3p47I"),
    ("$2b$09$eac6sRLhHnDz97ak9T/Yd.0WuE5hq5cRMihMJbIKaVSoKvcbEoaLm", "C8LyXM/jhtfRrLb8HkDrtQ8N6"),
    ("$2b$10$pgwbdTC6.js5XrB/OPj5auklUCnnlXLbUQERWafjPtCLwSMgUJvhy", "Ir(MY(geFmW47LPJ2bup_)V0P"),
    ("$2b$11$c4C7XUwMg3fII/8nNXux4u9zV59XdRaFTiBw7HPX7yzEc.n538phm", "79DtY4dioKviHxjTFH0ydYN09"),
    ("$2b$07$IQsj9AI.rdVsVxIfn71XIuvBzVUB9RyDKS.PNR6etyoce8hRybcxq", "om2eK8tPG7z0fDkGT3AjcP_WXg"),
    ("$2b$08$gtb.aJ35YNE5weyUal/VIeK1wpqWAawJO7pK/gY.ai5VSFIaEscO6", "SsFDqSYK/Hz-DOlV/kwng_Bnqb"),
    ("$2b$09$ZZMOtJtdPTTGUL1gCLlO/uCkuxTIw0jrO8iP1gDrX821TQ/Sf/3OW", "BmS9LYPI)WTsRjJm9p7LG5DZ51"),
    ("$2b$10$/CDOMx0WCwDd0jKJNxe/I.2W03Afh3v4H86yUth4UFhfutWpN8e.i", "EvEtvJ11RQHMbr0qeyiU)//Mx4"),
    ("$2b$11$SDNOAMqtuZXh65jaMpHyAuK/Z0G2AJBaRI8jqxWp5MaIGSmeHJmn.", "42DlJl(OSAjRf1-YY/pwMmw1N_"),
    ("$2b$07$VfuwwRJl1Au2tjMve2IYQua8fn46n/rZlnD9tc4rD.Iz5.VDj8sNa", "Omn5mIv1NyZewcNshgZhNZMN_(U"),
    ("$2b$08$QNcb5bxFyimlsY8H.X3YxOnd7fkmYQg3PCld/zcbUaz7sWMc46Nuu", "srnR4Fez1EfS8WPsPDDOL0KUeXH"),
    ("$2b$09$l2zIU8sOIUeQ/8iZS2g9BeWGSLkk29o/o/tClMdjD2e1U5xKm3URe", "3flqLzF5JVcxO4-gEn1b)cdAU_I"),
    ("$2b$10$c6YIL8TAKlBNjO0dS7fYyOHsf4UDbCHqGl0m2yaIuWxapZ6IWYokC", "fF9qPFeNExMdZ2DgljQqdPG)C4N"),
    ("$2b$11$BwmbDuOQSCIWdK1/lzjB3OdT9UhBopY2kdmhSqmP77Y1pzkJlkaLG", "jW-(ZgmhiHBmlS(Hwggk22NRb(5"),
    ("$2b$07$2B0TaC6o1p/89Qjy.FT2gep9..s2zSaxusghgUbh/UKKvCRt2wABK", "PPPMQS8t2zN7IFH7/kcb0bpc2Tzm"),
    ("$2b$08$gJA0ZP6.4UyepOn99qJCZuHfNlyU64tU.8nT6T94EJ6tSW9xk2Qy.", "rz5iPhPGmVuKehgG4XVwWExiliU_"),
    ("$2b$09$0YV2AOi732S9dKOAdy47BORW7cSXxjjV0oDeVaMJWDRv/Aj2lPN7C", "qS6L6pPimsgkCvAdd2S/dpEGy1o2"),
    ("$2b$10$d4q9Zz7Psg2eqsF3rUt/werfW6HqTRpHt6kT6lqYzRnMn03ZqDJQq", "YTRTGGbpnBopyFHJUq_xpPzrBXGm"),
    ("$2b$11$27kCoonHJdcqO7Wvxz.BzuE1gJTpp14/UVW9vFxqEJOggjPGRzCoi", "_VuTBQCGODsH7FxzxxHHEu898)qm"),
    ("$2b$07$NvXRgbihCBeXVpPpvAezZeQXksgXPMBYDFkXEcpIRH6UmP95Bl.UC", "dq4ybQ/Vk4FOVnJZb7OVos-TYy/52"),
    ("$2b$08$QJeSOjQBi93uaXg812OKLOS6k7l80Uht0LpGhY5etDpN.u5et6S.y", "qTCqRbaCD/C)zjr8kYFe/hZxhw0L7"),
    ("$2b$09$hs01cqKPwmuENvrluOdz0.5qyCjH/XmOeflhkJK6yz2VHOsI/W2s.", "WEaJ_I1Oh0eQzpWq4eJnZZCG)Ukwg"),
    ("$2b$10$2HUUqKTQxX7XWBcZnuya6.Xn4tL2jlocjNyTSiRKHr7gGMjqEm.GS", "18PEg6cPl0cEH1cCmDv/z3Js9HTbx"),
    ("$2b$11$KDj/nr6OzVNIMr5yvgA0q.DjgwZIam8BObNkRolgYIRpX5UfxaNHS", "hhhdQsNhQEi/aMq40dtOoFOMatGTB"),
    ("$2b$07$MFQtmUnHgO8.BMISMi4Apup/Ht/1VUCwGW/xyk4RIe8ZJH8ZLOoq2", "D0DX855Pubr38UUXCIM9UYvKMyZsBz"),
    ("$2b$08$LEuuCZ2vXymr0LSBUxlcLefaCn4zCjM87pdJ526C2cctCixJlKIOm", "oh2cM0EMh/cMluKER3q2i2R9K-mbcI"),
    ("$2b$09$c3gUnFuBeurXJ9AHdNCHOuR116AYZ.B7407v0DGY.4yiIaObifvc6", "PwoDqAhWit7MpXuvolPxNuLKT(DfFt"),
    ("$2b$10$B9EBTffAy6snzuwK.naBBOGjUK7lAv5w.WpkeMFaqAlplK2JUVn3C", "xbEQbaNp7EUDxtiq6nFRdTHAD/DJy2"),
    ("$2b$11$f6oH.fEsJ7eE5M2.g/bVxetVVAtHqfOT4zRlx.AA8ziMVNWbdTfw.", "cgY/Mx7bi_7AX853U4CacJ/p8SsWC0"),
    ("$2b$07$TE1CG8zXF7BsgjtC4z/K7.sa/M7RZGv0yomunZ2ly1LboBHJ70ANq", "5SUrzUAbnfu9lMkXdb(jA_D7n7P2qu7"),
    ("$2b$08$vM675.6hJcAvmatWRxhIfeOI7aojfdHYWEnFcJY96UTg13eq6/a2y", "JMlfIMz_5TJPjTHWYcnX693H5TTsmfc"),
    ("$2b$09$4l6pM3uQenmwdcAxc6FTd.FU9fYG0s5h6I3d8NwR9oYTkcsOOzcWu", "8QzPR4f09QZSxJO1JVoMhKzWg)hnRip"),
    ("$2b$10$F1RdsvUli/Guaa.6bS7iMeo69eWlaGZnsfWKDXWnWcC/AwnENNQMK", "_oBgtHguCP7n/CCHIaeB4tv3WsoGGpF"),
    ("$2b$11$BZYtq7u8IpojDcYBQzNdlePKKfB1n9ugVoUab7UieCVHiuTwePXdq", "K(RMfi8297_W4tg_RfQyl_qll61e5ap"),
    ("$2b$07$zk2zMO77tzu7M3UlZsCevO79i290emv3nwehFfq3EHYcIKG/Ah0Bq", "eARB(/nrlRceZnQKmg9qZt8fruBghHJI"),
    ("$2b$08$Nspb.SrdFAUeVO8GbN44rOWQg7wJ/NPBjJJXR.CvJZhQkS/V76GEC", "swDCb-mjkt(gyfsJi7VgMbPb1r6L)l10"),
    ("$2b$09$1b9GQLemaXTDXbxtgNoTnO7sDBjnclXBYZ9IM/Nmnx.4TbFWnL2k2", "OYm5W0ZjeTJow3zqq64RShqFUIC/AsNC"),
    ("$2b$10$7ceKL1MvisAJp1MLnsRJPOz6ieV8zyEMp/fPZnRLjC8yiS6PuVNWO", "RSg(Dpn8-Z_7PUwIG4_oXzrBaudGXlgs"),
    ("$2b$11$8cs2s07IdjMZieneIaFNs..z9QeuRldO6/zf.CiLL0JRy/s//imEG", "jbdQvYSHNQk(VMBamMBMC/fuXlumRho6"),
    ("$2b$07$drTLfHqefuVMD46EjeLzyObleWhW6Pf5Z5wE4XRMqsmDA10HRF91e", "EU5LkwONRX/cpeOHngkBA7Gj9IyQk9p6L"),
    ("$2b$08$GFftm6FXLEDYseGAfstJjOz8a4OLqqejA4y.HLnNJMhcOK0WcUrsW", "ODX5DYuQOysHQrA(W1iO1sJ_1OU(mFOcL"),
    ("$2b$09$laK1dJDZrej34YXxqpUiaO1E4EIyeJXfjNPduMlIxjVemNi.x7IKq", "UNpRVXBBGWGH9)6F42pkKlJB4/d198J)e"),
    ("$2b$10$RscV6AIlCUiJQU/fYY9ydu7vXSIMclqIcnaHLMf03gkLO74NVeuvm", "s0spK24awF80WN)KTaajxMjH03tMK(LvD"),
    ("$2b$11$C8atAQdnQPPuRtufyOYtk.SRtTZ4Y/g8gvpZjRXE17Ok13G6g9OgS", "BeSKFcEBVgszs0G8ONVXXB4KqoiZS1CbE"),
    ("$2b$07$Tip9boIRcerJcfnxNiBF1.MU8Q1Z5WVqn5aa5Na/RMoSMQflBET6.", "3xAijXz4W3mv7xj6PNti47U62hgTeKN0qd"),
    ("$2b$08$HYJXUXWKFwqTD82IndOOqunJyUxReLDAzlHGKp9U/Pnvx9XIxAesG", "m_61yFFIHYM2-Z7_STQaIn76C7GXOC_qoV"),
    ("$2b$09$RvfHmI9yTtz4cCYFSFctHubnANOFHFG8ga0/GRNGbHiuXplyWpCN6", "priUPPW9)6wrF_RamOdJkNmKQLz_Vhg-ew"),
    ("$2b$10$Wq7jziGnk7atMuRpLLzbI.iCXZE6p7M41dGYy5sfGXuk30q.O5CmC", "h0snh_mIOqYv9hNKC((5g72pm5vuMa96V/"),
    ("$2b$11$RvDXAfhA84z.sPcbcrysDeG0sFPZFrwM/lZKtSQhos1X1no9WJHe.", "twVeY9JYI/srRUZ8EKENG8RB_HEYpBmJ/x"),
    ("$2b$07$muPQEPXokq9RvJKLbZCJu.JIL6XH9oHTwrCC9WDMAMyPGc9OrWUDu", "eofF7r)h8tegoZaN_ZmaeYRsKSVE66P6s1g"),
    ("$2b$08$ZD5sAHulBvxyQgiF4sDo9.Vkw6bO9XGWbw28X6lrv1ZeScxgi6rni", "Q8dJ0_nt)FzvP7ABTcRipEyLE44GLNrowZ7"),
    ("$2b$09$IV2A63LwWZRMDQxRE7Jt/espoZHezG0k/mdQgNNh2RVSc4h87k7Bu", "jpmGAD/sJafr5(zBKmnm(O5iHbpX)n(Fo1W"),
    ("$2b$10$xz4ccMe2Z7QNUD4xhpyf3uGR6SyZQwRSdA.zs./EQfhYZEJkwLWgi", "Bt1Tsjz/qdYcR0tbpKj06K-bn_d/pP88jEK"),
    ("$2b$11$WoMM6KvW3pQKuMjPEm213uhUgOtRona8cQqG4e3QQNNlS9jvOVplW", "/xv0YX9(nIkT5M0W_NCdRduUvXqa/dYYEVr"),
    ("$2b$07$ZMyzTM6jA523Wkc8tSh9H.WS2oX28oqpa3VeWzfYDdiwpBNNL8ppW", "q4Pe)zg-99afXrcuDJ(vCnH9XS1WLP5A6RWM"),
    ("$2b$08$b5WVM1wo3.9E1MtM4rssIe0TFIOwWibo9pxtgFeEZyMZ7coYau9GW", "qepGnuCjcg_7pmKJl6yS_fLkiUw8pmvLBRqb"),
    ("$2b$09$z148jE7DoQ11Clo0BoWOluvej2rVUNWLRopoOEdFWmHdMgmN15RlC", "92(3OeMvSbpDaSOSMP1KubneXGe9/_Lpi-48"),
    ("$2b$10$5/bT5ermC1A.NZIRETPgROaFhJr7ycESdnbCfHS/hQDKkMnyoch.2", "swensj6w5c3ZNxckKyyYOeYAdE7imY/tkCgv"),
    ("$2b$11$H5JFuGOhDRct1W2FQ6ZZb.2VXrwSrOkGZCUJSaePMm6b6AIJc7cf6", "v2QJfjJw-XPrauZqV//wBoRAiU1dmJj9fcEj"),
    ("$2b$07$WxT9b.lnZ/oDc8Ha3Tlj3OyWLor2W7wWmGKSDgw0iaC2Ri5NNM752", "-poJJ8e9CUMOdAFa8/jyFmG/T4aGo)zFxhAhW"),
    ("$2b$08$fKHJRM7T/zw54YYsOCfoXO98ngY..xtC4LaTIOyM.V0txrAB8RsEW", "/_DP8Jxo3DsNq1/A-sOD_E9fYJJoZQAA9jZfS"),
    ("$2b$09$GIqGYpA0t1MqY/kfXhkOWeUwP2EqsEpHzsUuuX2rSa.v8NJTPEvVO", "9Mvyq_0HBtKOAs6(bvru2oAbMGJMfBORGwolp"),
    ("$2b$10$Ue1LXkCECZ9y/5KMwtLG..Lcr287SYyhFI52Yx8QZQumsEn68xSdq", "6K(8Uca3ZQ9B/fToYu-__OEuUNjb5jN_2aTp8"),
    ("$2b$11$kNf59pnfEwDv3pBptH2P0eTnQwxQxeT07FdjBpEQs/v9gBdQ4MZIq", "OdEd_PAhB0rDj7HJXQoZmHeHmWCEtjswJ6Ljv"),
    ("$2b$07$2HPQa1SucUvBNeySICwiXu3CHvCJrt1ru/r/O1DWYLLscjot4NSbG", "LMsku0Qh__HLP57UZrYz9gVvNyj2YIbgq7RE5D"),
    ("$2b$08$2HI/OhoH/CFB0e9xe2v3fOnxFUBc1KvWg6M2wMPcoyEuhr/vFZNvW", "IBkc5rJo2wpi1ihxyTDjmje91YkDKhge0xIndi"),
    ("$2b$09$yH8z8vJ01IG0OBUEXC5SyekhIG2q07I2BTO7Z0gWY76t8AT37bpl6", "uEZuxWgoXrMLVCrs-KTsyMtlpQX)kMEqBFi2RM"),
    ("$2b$10$hqOUjtqtxkGXMqZ3DjMkguaYaZlHVz6xwe/FUXYg1C/neeqJJh5cy", "6E_YaWT5j0L/)XIF/6NgV5ziperAzuNgik3DZ8"),
    ("$2b$11$nZzCk0BkdcSs6HwfhtLVge5eAVwDgB84afordLd4rn9scuk.wZAoG", "d_l4RgDM)J91tU/4kY081iGWMrO1kUO/)aF(g("),
    ("$2b$07$HXhBXVjhTf3yYqCdSuNBEulifYWHGvdmo2Q7psZJxsg5YIL2n32uW", "_/PYiEKrpOify-YXmVMZ5VDDwneW9O3N3C9VvzR"),
    ("$2b$08$/ORqaMO750CopAaFfXBIrOtDEnH8cokGdtQGfgQNhxH/hJXIPgb9a", "6P3lke-fqtXi4KChs(nBbY1m_PC/o-8B7u0KxHC"),
    ("$2b$09$cElXgesxkPktjMvHTNng7uQxtuAR7C3dk00szzdMxLSxbuuO3mEre", "_w6Jt0teQQzU-fV7U_BJURvH3nzZHWk)HtdfMyc"),
    ("$2b$10$zzm2ozi98FKAjlOBHPyQkOny0jfm8JB5fX9izErqnicyMqFqP0Epm", "VCIBQKNf0ANAuRAxp1LeLqff7vGnwQTJMYyNpP5"),
    ("$2b$11$Dk1RzP7Q6BBp5Rw7t.xTc.SXm2LWbzP.9uNgTEgbhJbk8S0AQkIoe", "PYPL022951SPXG(/3ZBvVe9Wvh-a4Ontnz()GCZ"),
    ("$2b$07$XF5CcVXCMBhDaLgZoHlJCu9u5WUI8SX916KlVLAEr.Us8u6LB2y.6", "1rrFzF/atw4NychXSQ(YUHAW7qdb9z5uKSUNa_jF"),
    ("$2b$08$cxtL4vYGiL76EyTVjhi.uulO7rDIU9.mqYsjtKx.lC2i5YxbxQ4Mq", "EJ3YfH-m1eLr5F)CCb/2xz-GEUkC_pd-Qrg4bQa8"),
    ("$2b$09$s9wUyRSZkjR46v2gjeJM3O0KlL7G5H.NiEf6Q.zQWL8kSn1URT8JK", "CgpdpUW5gH(KVUFbPC/KYPWbbFvdiW5JGIkPuek)"),
    ("$2b$10$A13mYTSv8KI/RXWBlc6/BeZQJ9FjDCvR6ZQ03YTRPaoM1g2LcsthC", "6MwiW5ng_ZpflvkWBBXcurPorY()PUg/utF-E6KV"),
    ("$2b$11$xVBsa7.CucZYM2SWsW/wCex0MHaqulqW1ns58ygttDOctpbDOOMDu", "VXt-01-oaf2io2maXIhFrBjnwEM5Ofy33E-qpitY"),
    ("$2b$07$Nvhz8s2lJjWvyzyDIn42jeA2AJj7Z6KDM9VmgyZZwodgT8EEh5G/G", "/R5H5/V1_orduArzatYnWryBCz(ouiSr3PrVg4()n"),
    ("$2b$08$rwQl87cPygHWJZ/rd/5hVewBbGBmlMm.SOfuNdQ7tTd2cgXQqn47m", "ibH8i5(aQ88RCkHHvsNlUI7i(SUFflyiaaca4VTBy"),
    ("$2b$09$id2pTIjVMZkczCSKKRGFeuwWMiI6pPeI7Zz/XCbuq610JHP8tfKNq", "4kU4hy55d-e4NfI-YbVIEq/Im42ra0y6NhHQGkQ)B"),
    ("$2b$10$.u/2eooDBdrkIfOaEyd6fOkp9YimGy2GUGGXaq1EsGXNKwJUGzWWa", "am1HFaHkct6p7xKU1/jTSKoIwkv7UYasAWv1tEktX"),
    ("$2b$11$Ub.0waOUmWmwg2K7iM.QwO6xhcyonHRIoZUuHy31LWWt8K8IiS3mq", "fqPyfxtKM-)sSlzFECXZMHYg5ObTM0aK5vgU_O3D_"),
    ("$2b$07$RPXAECJ8d0aJFUX3MB6lJ.7uGhB0wyd2DeuYk9PYD6higEjuPwoyi", "tfqzznt-oc7RDVTiH_dAxIYwNO8ChkHLk2pSiIqMr-"),
    ("$2b$08$7OtF025/jRem/QfvVXCXR.gDmfrbdSLb/3o/7Ju.pEi5Htj3UW86y", "UNeKtuR95gX6)26Nu(B)htOXB2RH/d-Ni0IWmXo8q0"),
    ("$2b$09$CoPfzM9hlX8rnZlkHt2pLO8OiTWVGrDECDFigcSAQTVjBn8ApMgOW", "PHeGLtFLqX80Y6v-jpV6bEu)y23LeILMrzueA1EQFR"),
    ("$2b$10$7GOr0gAWTe9my..VviQSreIHM/Vl9mG4Ol.X.WfR/i9vMnbQ3hY/2", "y-kbA72Px1HbVlrzknUmY1nvUI0Aq1(FmETE8S4FiS"),
    ("$2b$11$Xk5Z5vcZvrL.NRmrOgPZpuvL/cetvqnBPC6xi9vxvF3FnPMJgO2rK", "gBpMh(koKb2yoXgDjxoIyVNPA58_LJbY2SF8sCZsXZ"),
    ("$2b$07$5WeseIBmM9tIfMpt2Kt3OObvnNE65fLcvY8hmIz4C.w2BY4BR1NT2", "k3ZlGQvIMnItjjjxFuCXvt2GqhhKsp94FIusBaIDXPE"),
    ("$2b$08$FTHWtG9g3e1pIe4DfDkBVuvWc1gy1Eg2jC1pH8QWMD5CA1DtPGWIC", "(xh5c)/LK8r/I(s4_bQg(2x9ikbPUrwtv0HOH3zTEGr"),
    ("$2b$09$p25qIths6TJYmfQAkmsWauRg8PrgQ8RrHFn/A3.OcE9HHgOzNrN2m", "KL8XCtWL54bayH1mraNL9nTuEoPo2wAQ9eqJ8x2y2V3"),
    ("$2b$10$pYFHo5Gu2yCqQISp2PXgY.gAl8m5ZLcizqNvKNKXgEsR5Cy4v2xbq", "/UrofacVPebCs5vTaTqZl-yClkLvHgFKIq_Uw671q4k"),
    ("$2b$11$8LK6EjKrAiXPDUET0YXl8urxOWRAmAqYFGVxD5lwpEC3fzlkT5a5i", "xT1_5Un4DpnJjicTInmk7Sh8TyDqCcFhzx21Hn-G3)/"),
    ("$2b$07$dhqxzy3p.Q3SovMVpGn.Fu84nwp.VTjshZnzds0g.hVkHyARFtN6K", "ch63eEWA0S3lSZ3Z6GF740ieZmwCliu_UGVOcozBX2oT"),
    ("$2b$08$yQjENIrZJ3FGViAZb5KSKuFg/UvG4qQpWGP9m/Y.YuqY1Jb5G8zUm", "/POfy_wEA70Qs50EsnGY(ZkPXew7IW8dZCdmjSI_7N6u"),
    ("$2b$09$ZbPPOe58hN8UO3flkja6.u.esDsT0aRR7FcHLQplpwBjgp2k4vTPe", "nC6UssX9tXVxTx80Hcy0DoLU0)6cFbTrXF0jQiyF-q3i"),
    ("$2b$10$Hh9bQj7w1BEjSD24917rI.24CQ5/VFmja7YxEKWidDwzseFrOuzTe", "y7/m9cP4arcRH(CjtW/)0dgiDBkaLTHxzqQ8-77Jwdjh"),
    ("$2b$11$V.HICflfd7tnG2xqzDA2yOrb692ZMJYCLnMRsFbZsKWw3JkHSRURa", "5IAFaFFwvF-xJ7NwEHwYG9Q7q74qtdHt10vLE2LFGwPR"),
    ("$2b$07$ECszlgxmchHoe6IIz7jQUuGbrzRYxlz10/a80Bvve9BUHuXEKEysW", "MPrtrYbXr(WVQUlxGa/UAt6gEsi7O1tWRx(rRkR1bMur_"),
    ("$2b$08$KWUMwrE1NLYVsFzdXTUr7Ob0E00E.LuIKIZM/Xnw71h38.dYutgKm", "IJwHuFcPh0ZE-xQM4Y9t0MObsQVmJriUsVrMzNReSs-IW"),
    ("$2b$09$DlXMCLgf1gPNOXmSKY4HdOkJRF4N4xwpYySfVoRdM9njbZeMqfefC", "kJaODh34VUbaCEuQ1bYYltwcjyx5NYfwxFF85xWh/tfyH"),
    ("$2b$10$LmRYuiyc6Lzuhkc6C8hDeOvAUMXMg3ZRY3cIik5Q4E3fT2hU22S0K", "TxwYDS1ntOLM(iqIyTwcxJrbInHPKFZTdyhme1WokIBC4"),
    ("$2b$11$DDGBEwGZ0oYZ1tPGQcvcLep2c1B4CF85WP1TbAvpho9rRV3kXLY9e", "VWr4F9bgzQiSlRhHqFYw(vUDSD0g-p0Rj)(vrNjsmtQ80"),
    ("$2b$07$egcmrHHjcval8Rut2Ectv.orUWchOgoVJL0fjgLub2semeu4wadkS", "jFvAqI0SJyIJFyBhsFKq756wTw8l5vLzf72xZCEA3szsSw"),
    ("$2b$08$MhDT0uDvrFdR2oYxdGNb3.SSvHlD.geCLE1zi4PmRMbHFO8orvAYC", "GCckf5U2aJq1VyUYkiKl9D3cDmQl1qYZ866rLBgV4I-ssN"),
    ("$2b$09$NoNSluwM5pWN8kmxGQTtT.0/.5vCLkB7AtocoXHFTnwNJ95GKrtv6", "Bfy8iwMY27Fh)wWFX65JmeMbfDN7guZbyH-cvnX4-avj0-"),
    ("$2b$10$HHNYzkjWtMORwQ1HarTgPOQIb72g98et1EU9Dw9D.pOEKnTbiP6u.", "Xy(df(nNgRN8qKj/SUl_stxDXyxeg7A9w_B1xF4rOpq)nA"),
    ("$2b$11$iAOYWoB5CJIo3KSvZZO6G.rN1Fax4CnHgpXBSqlOKImYkcnXDXn0y", "zRzItp0pHFAo(VAoVs86_9dlwpludV5Fa08XtGlpl4cOzd"),
    ("$2b$07$ecgw6KPWdGtPEZBE/QQ/VuXU51H4LEkRAkmno5bP4RXZ6gT0vCBXC", "d748uRAT3jaNquMoXnh40HqihY)5Lv1zaQOzJ8EPx(kTjK5"),
    ("$2b$08$W5jCftCLqpMhLshBT7Eeb.EjyPHT5dU2TNZp4CogOiKSiL.xmX3VC", "Uov3ey-bndlEitfL7fWY4)-0Qr2I(SOlTAqcCBFIVjZwTG7"),
    ("$2b$09$WyQQNT.1Bpmh7i4EuHTXKuQxizF570VNnARWPfulC0zWQfI2SYZWG", "HHcrFbVW(Rcv/kYGDc7tCLnZG-qMgg45q9aONJ9MOTJFs4-"),
    ("$2b$10$/CYwrr3FwbJVzgJb3/LHoenDr5pz/Q5MxkqNUxXd2Uxb6EXikLmzi", "jvW908uPaiBcp-LVKs5BiL)6_qQz/qRx)(RWuy0oncvuP2j"),
    ("$2b$11$W7v36qekMHpvlIHWJQWGd.Sa4oEDvW4zDNghFtosc1tECmroCQOue", "pVKhkF8Q(mfgGmb(358N7L6F1Ifzl034jg2p(ZYJCtWSa6I"),
    ("$2b$07$ROPOqiV87VZkqOlpuKDPqOqPzGTMFFJOq9deMqrtFvP6ATe8SPKqy", "1k11TE-4_4-WQ2MiH4FbZWG_5oY8vQ8Vsf2TxIr_gmJtukOG"),
    ("$2b$08$WCgm0Zwnvw4yQRfpgjFaneVqjaMaZ2RmNyDtjnrLUTS0.PVsTQmqm", "WHTre/ae)AwtVE52yboEAjYEIKudcSTmEL4Cdvs-hYUMlh7n"),
    ("$2b$09$qckEAVaTenkVXubsCFhQOOul4x6aYrnGotpk/gFgvIssPAw1rdSX.", "iE)UTuAnQ5KmSy9FIPVN5HNa/(f486jrlVczS)C4g5tN5DCm"),
    ("$2b$10$neSqBHGBAAlddi67jfFfm.FHptdrS13kATIprYfA43cRQ.xipG/W.", "Tm(s0ZtDbjWJkRzjQcTpCsboAS81S8QJQr-lkWv5uM6OIB_5"),
    ("$2b$11$WUPDKgpAj67PEZnJqn5wteNrQkDNWb3bUATEulMO/TFzojBVaWjkG", "AqM6dE0D7-FzhWC8fxkOXl/xc/R(PrbDywJ_UndfBy_Em39s"),
    ("$2b$07$0dWyL8n2MjSq0wYwfZTJW.O5ucqSEuThlpFK7KwiBJUV837LKvvXi", "uQxVl4Pu))_ycVJ4O0XP-MRayS(1q)ykTkslXodcBC(/gEHl1"),
    ("$2b$08$Wf9XDaa80lsxLkk7TjK5IuZR.F/WwdQpbc88N895RWYezjv64wt/q", "5IhjjPqyu)(aEoVax4rKp8DVu8)giu7De6ZnTPuiD9d-1G/R9"),
    ("$2b$09$frQFOQXuLtVCD3mOTS5R3OvP01Hm98Gl5vDC3Cmwz.fQSvxfbCzB2", "Fz4hNDgzDPHzZaYr3daI8(9Lsvm4jQisFszF2tU0V4yBnAm9-"),
    ("$2b$10$a2FXNMq6CxQ9Nl0ARtJ1/eSyUTMbKnJSPU8WcfNjRrTSaalc0Nkj.", "oUP_iH)CgAiNnAmqMApgqKwSTBRMMEb0_jN)znL49EtPTNeaB"),
    ("$2b$11$Zk9MmsRcAMDre8zniYoDlu/NnLnDifis7VayPn59di55HEIoktuQG", "32TP54F6IiHk-0OlJDsQAP2vOMpMggL_4o5KXySR11UiPF8Vy"),
  ]

block: # Test against python-bcrypt
  for (hash, input) in testHashes:
    let salt = parseSalt hash

    if salt.costFactor <= roundLimit:
      doAssert verify(input, hash)