push_textdomain("tribes")

local dirname = path.dirname (__file__)

wl.Descriptions():new_worker_type {
   name = "frisians_stonemason",
   -- TRANSLATORS: This is a worker name used in lists of workers
   descname = pgettext ("frisians_worker", "Stonemason"),
   animation_directory = dirname,
   icon = dirname .. "menu.png",
   vision_range = 2,

   buildcost = {
      frisians_carrier = 1,
      pick = 1
   },

   programs = {
      cut_granite = {
         -- steps from building to rock: 2-9, min+max average 5.5
         -- min. worker time: 2 * 2 * 1.8 + 17.5 = 24.7 sec
         -- max. worker time: 2 * 9 * 1.8 + 17.5 = 49.9 sec
         -- avg. worker time: 2 * 5.5 * 1.8 + 17.5 = 37.3 sec
         "findobject=attrib:rocks radius:6",
         "walk=object",
         "animate=hacking duration:17s500ms",
         "callobject=shrink",
         "createware=granite",
         "return"
      }
   },

   ware_hotspot = {0, 20},

   spritesheets = {
      walk = {
         fps = 15,
         frames = 10,
         columns = 5,
         rows = 2,
         directional = true,
         hotspot = {11, 24}
      },
      walkload = {
         fps = 15,
         frames = 10,
         columns = 5,
         rows = 2,
         directional = true,
         hotspot = {10, 26}
      },
      hacking = {
         fps = 10,
         frames = 10,
         columns = 5,
         rows = 2,
         hotspot = {17, 31}
      },
   },
   animations = {
      idle = {
         hotspot = {8, 23}
      },
   },
}

pop_textdomain()
